#include <bits/stdc++.h>

#define ll long long
#define pb push_back
#define mt make_tuple
#define uset unordered_set
#define MAXN 200010

using namespace std;

vector<int> g[MAXN], graph[MAXN];
uset<int> erased;
bool visited[MAXN];
int a[MAXN], parent[MAXN];

void gen(int u, int p) {

    parent[u] = p;
    for(int v: g[u]) {
        if(v != p) {
            graph[u].pb(v);
            gen(v, u);
        }
    }
}

void update(int u, int c) {

    a[u] = c;
    for(int v: graph[u])
        update(v, c);
}

void dfs(int u) {

    visited[u] = true;
    for(int v: g[u])
        if(!visited[v] && a[u] == a[v])
            dfs(v);
}

void solve_line(int n, int q) {

    int b[n];
    for(int i = 0; i < n; i++)
        cin >> b[i];
    
    int br = 0, last = 0;
    tuple<int, int, int> inter[n];
    for(int i = 1; i < n; i++) {
        if(b[i] != b[i - 1]) {
            inter[br++] = mt(last, i - 1, b[last]);
            last = i;
        }
    }
    inter[br++] = mt(last, n - 1, b[last]);

    while(q--) {
        int u, c;
        cin >> u >> c;
        u--;

        int index = (lower_bound(inter, inter + br, mt(u, 0, 0)) - inter) - 1;
        if(index == -1) {
            inter[0] = mt(0, n - 1, c);
            br = 1;
        } else if(b[get<2>(inter[index])] == c) {
            inter[index] = mt(get<0>(inter[index]), n - 1, c);
            br = index + 1;
        } else {
            inter[index] = mt(get<0>(inter[index]), u - 1, get<2>(inter[index]));
            inter[index + 1] = mt(u, n - 1, c);
            br = index + 2;
        }
        cout << br << endl;
    }
}

int calc(int u, bool x) {

    int ans = 1;
    for(int v: graph[u]) {
        if(erased.find(v) == erased.end()) {
            ans += calc(v, x);
            if(a[u] == a[v])
                ans--;
            if(x)
                erased.insert(v);
        }
    }
    return ans;
}

void solve_tst2(int n, int q, int u[], int c[]) {

    int ans = calc(0, false);

    for(int i = 0; i < q; i++) {
        if(erased.find(u[i]) != erased.end()) {
            cout << ans << endl;
            continue;
        }
        
        ans -= calc(u[i], true);
        if(u[i] != 0 && a[u[i]] == a[parent[u[i]]])
            ans++;
        else if(u[i] == 0 || a[parent[u[i]]] != c[i])
            ans++;
        a[u[i]] = c[i];
        cout << ans << endl;
    }
}

int main() {

    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);

    int n, q;
    cin >> n >> q;

    bool line = true;
    for(int i = 0; i < n - 1; i++) {
        int u, v;
        cin >> u >> v;
        u--; v--;

        g[u].pb(v);
        g[v].pb(u);
        if(abs(u - v) != 1)
            line = false;
    }

    if(line) {
        solve_line(n, q);
        return 0;
    }

    gen(0, -1);
    for(int i = 0; i < n; i++)
        cin >> a[i];
    
    int u[q], c[q], color = -1;
    bool tst2 = true;
    for(int i = 0; i < q; i++) {
        cin >> u[i] >> c[i];
        u[i]--;

        if(color == -1)
            color = c[i];
        else if(color != c[i])
            tst2 = false;
    }

    if(tst2) {
        solve_tst2(n, q, u, c);
        return 0;
    }

    for(int i = 0; i < q; i++) {
        update(u[i], c[i]);
        for(int i = 0; i < n; i++)
            visited[i] = false;
        
        int ans = 0;
        for(int i = 0; i < n; i++) {
            if(!visited[i]) {
                dfs(i);
                ans++;
            }
        }
        cout << ans << endl;
    }
    return 0;
}